﻿Imports System.Windows.Threading

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private gridCenter As Point
    Private textSize As Size
    Private scale As Double


    Public Sub New()
        InitializeComponent()

        Dim tmr As New DispatcherTimer()
        tmr.Interval = TimeSpan.FromSeconds(1)
        AddHandler tmr.Tick, AddressOf OnTimerTick
        tmr.Start()
    End Sub


    Private Sub OnContentPanelSizeChanged(ByVal sender As Object,
                                          ByVal args As SizeChangedEventArgs)
        gridCenter = New Point(args.NewSize.Width / 2, args.NewSize.Height / 2)

        textSize = New Size(referenceText.ActualWidth, referenceText.ActualHeight)

        scale = Math.Min(gridCenter.X, gridCenter.Y) / textSize.Width

        UpdateClock()
    End Sub


    Private Sub OnTimerTick(ByVal sender As Object, ByVal e As EventArgs)
        UpdateClock()
    End Sub


    Private Sub UpdateClock()
        Dim dt = Date.Now
        Dim angle As Double = 6 * dt.Second
        SetupHand(secondHand, "THE SECONDS ARE " & dt.Second.ToString(), angle)
        angle = 6 * dt.Minute + angle / 60
        SetupHand(minuteHand, "THE MINUTE IS " & dt.Minute.ToString(), angle)
        angle = 30 * (dt.Hour Mod 12) + angle / 12
        SetupHand(hourHand, "THE HOUR IS " & (((dt.Hour + 11) Mod 12) + 1).ToString(), angle)
    End Sub


    Private Sub SetupHand(ByVal txtblk As TextBlock, ByVal text As String, ByVal angle As Double)
        txtblk.Text = text
        Dim xform = TryCast(txtblk.RenderTransform, CompositeTransform)
        xform.CenterX = textSize.Height / 2
        xform.CenterY = textSize.Height / 2
        xform.ScaleX = scale
        xform.ScaleY = scale
        xform.Rotation = angle - 90
        xform.TranslateX = gridCenter.X - textSize.Height / 2
        xform.TranslateY = gridCenter.Y - textSize.Height / 2
    End Sub
End Class
